if(typeof(CustomEvent) == "undefined" || !CustomEvent)
{
    CustomEvent = function(name, obj) {
        var event = document.createEvent("CustomEvent");        
        event.initCustomEvent(name, true, true, obj.detail);
        return event;
    };
}

// Other useful objects
function KLFunctionArgumentException(funcName, argName) {
    this.funcName = funcName;
    this.argName = argName;
    this.message = "Argument " + this.argName + " should be defined while calling function " + this.funcName;
};

// Helper object
KLBrowserExtension = {};
KL = KLBE = KLBrowserExtension;

KLBrowserExtension.debug = false

KLBrowserExtension.addLocalEventListener = function(event, listener) {
    document.addEventListener(event, listener, false);
};
KLBrowserExtension.dispatchLocalEvent = function(event, message) {
    var event = new CustomEvent(event, { 'detail' : message });
    document.dispatchEvent(event);
};
KLBrowserExtension.getEventUrl = function(event) {
    if(typeof event.target !== "undefined")
        return event.target.url;
    else
        return event.url;
};
KLBrowserExtension.getURLDomain = function(url) {
    var tmp = document.createElement("a");
    tmp.href = url;
    var hn = tmp.protocol + "//" + tmp.hostname;
    // // [FIXME] trash hack for firefox
    // if(hn.indexOf("www.") !== -1) {
    //     hn = hn.split("www.")[1];
    // }
    return hn;
};
KLBrowserExtension.getURLWithoutParams = function(url) {
    return url.split('?')[0];
};
KLBrowserExtension.getWindowWidth = function() {
    return $(window).width();
};
KLBrowserExtension.getWindowHeight = function() {
    return $(window).height();
};
KLBrowserExtension.hasDefaultArgumentValue = function(argument, defaultValue) {
    if(typeof argument == "undefined"/* || !argument*/) argument = defaultValue;
    return argument;
};
KLBrowserExtension.isObjectAvailable = function(arg) {
    return (typeof arg !== "undefined" && arg);
};
KLBrowserExtension.checkFunctionArguments = function(funcArguments, functionArgumentsNames) {
    try {
        for(var yafn in functionArgumentsNames)
            // [TODO] fix empty function name
            if(!KLBrowserExtension.isObjectAvailable(funcArguments[yafn])) throw new KLFunctionArgumentException(funcArguments.callee.name, functionArgumentsNames[yafn]);        
    }
    catch(e) {
        KL.logError("An exception occured: " + e.message);
        KL.logError(e);
    }
};
KLBrowserExtension.openApplication = function(url) {
    var opener = KL.createApplicationOpener(url, "", "kfpopener");
    $("#kfpopener").remove();
    $(document.body).append(opener);
    // $(document.body).append($("<iframe/>").addClass("KLBrowserExtensionAppOpenerFrame").attr("src", "skype://").attr("id", "id").click(function() {
    //     KL.handleApplicationLoader(url, id);
    // }));
};
KLBrowserExtension.createApplicationOpener = function(appId, text, id, path) {
    // KLBrowserExtension.checkFunctionArguments(arguments, ["appId", "text"]);
    path = KL.hasDefaultArgumentValue(path, "");
    // id    = KL.hasDefaultArgumentValue(id, "KL_" + appId + "_ApplicationOpener");
    
    var url = appId + "://" + path;
    return $("<iframe/>").addClass("KLBrowserExtensionAppOpenerFrame").attr("src", url).attr("id", id).click(function() {
        KL.handleApplicationLoader(url, id);
    });
};
KLBrowserExtension.clearDOM = function() {
    $(document.body).children().remove();
}
KLBrowserExtension.getGuid = function() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
        var r = Math.random()*16|0, v = c == 'x' ? r : (r&0x3|0x8);
        return v.toString(16);
    });
};
KLBrowserExtension.setInterval = function(func, interval) {
    setInterval(func, interval);
};
KLBrowserExtension.writeMessage = function(isError, prefix, message) {
    if(typeof message === "string") {
        isError?console.error(prefix + message):console.log(prefix + message);
    }
    else {
        isError?console.error(prefix):console.log(prefix);
        isError?console.error(message):console.log(message);
    }
    
};
KLBrowserExtension.debugMessage = function(message) {
    if(KL.debug)
        KL.writeMessage(false, "[" + Localization.getString("extension_name") + " DEBUG in " + KL.whereAmI() + "]: ", message);
};
KLBrowserExtension.logMessage = function(message) {
    KL.writeMessage(false, "[" + Localization.getString("extension_name") + "]: ", message);
};
KLBrowserExtension.logError = function(message) {
    KL.writeMessage(true, "[" + Localization.getString("extension_name") + " ERROR]: ", message);    
};

// WebSocket
KLBrowserExtension.isWebSocketConnectionActive = function(ws) {
    return (ws && typeof ws != 'undefined' && (ws.readyState == 1 || ws.readyState == 0));
};
KLBrowserExtension.getWebSocketReadyState = function() {
    if(typeof KLBrowserExtension.ws != 'undefined')
        return KLBrowserExtension.ws.readyState;
    else
        return KLBrowserExtension.ws;
};
KLBrowserExtension.makeWebSocketURL = function(path, port, isSSL, query, domain) {
    path = KL.hasDefaultArgumentValue(path, "");
    port  = KL.hasDefaultArgumentValue(port, "9997");
    isSSL = KL.hasDefaultArgumentValue(isSSL, false);
    query  = KL.hasDefaultArgumentValue(query, "");
    domain  = KL.hasDefaultArgumentValue(domain, "localhost");

    protocol = isSSL?"wss://":"ws://";
    query = query.length > 0?"?" + query:"";
    
    var urlString = protocol + domain + ":" + port + "/" + path + query;
    
    KL.debugMessage("websocket server url is " + urlString);
    return urlString;
};
KLBrowserExtension.openWebSocketConnection = function(onOpenHandler, onMessageHandler, onCloseHandler, path, port, isSSL, query, domain) {
    ab.connect(KLBrowserExtension.makeWebSocketURL(path, port, isSSL, query, domain),
       function (newSession) {
           KLBrowserExtension.autobahnSession = newSession;
           onOpenHandler(KLBrowserExtension.autobahnSession);
       },
       function (code, reason, detail) {
           KLBrowserExtension.autobahnSession = null;
           onCloseHandler(code, reason);
       },
       { maxRetries: 512,
         retryDelay: 5000,
         sessionIdent: "Vote" }
    );
};
KLBrowserExtension.sendWebSocketMessage = function(path, message, resultCallback, shouldReestalishConnection) {
    // [TODO] ???
    if(typeof KLBrowserExtension.autobahnSession !== "undefined" && KLBrowserExtension.autobahnSession) {
        KLBrowserExtension.autobahnSession.publish("message", message);        
    }
    else {
        // ???
    }    
};
KLBrowserExtension.closeWebSocketConnection = function() {
    // [TODO] close connection
};
KLBrowserExtension.launchScriptOnPageUnload = function(fnc) {
    window.onunload = function() {
        KL.debugMessage("close ws connection");
        fnc();
    };
};
KLBrowserExtension.launchScriptOnPageLoad = function(globalBody) {
    $(document).ready(function() {
        globalBody();
    });
};

// Messaging
KLBrowserExtension.contentObjectEvent = "KLBrowserContentObject";
KLBrowserExtension.globalObjectEvent  = "KLBrowserGlobalObject";
KLBrowserExtension.popoverObjectEvent = "KLBrowserPopoverObject";
KLBrowserExtension.fromTo = { };
KLBrowserExtension.getFromToHandler = function(from, to) {
    if(typeof KLBrowserExtension.fromTo[from] !== "undefined" && typeof KLBrowserExtension.fromTo[from][to] !== "undefined")
        return KLBrowserExtension.fromTo[from][to];
    else {
        return function() {
            KL.logError("no handler registered for peers pair: [" + from + "; " + to + "]");
        };
    }
};
KLBrowserExtension.setFromToHandler = function(from, to, method) {
    from = KL.hasDefaultArgumentValue(from, KL.globalObjectEvent);
    to = KL.hasDefaultArgumentValue(to, KL.globalObjectEvent);    
    if(typeof KLBrowserExtension.fromTo[from] === "undefined")
        KLBrowserExtension.fromTo[from] = {};
    return KLBrowserExtension.fromTo[from][to] = method;
};
KLBrowserExtension.whereAmI = function() {
    if(typeof KLContentObject !== "undefined") {
        return KLBrowserExtension.contentObjectEvent;
    }
    else if(typeof KLGlobalObject !== "undefined") {
        return KLBrowserExtension.globalObjectEvent;
    }
    else if(typeof KLPopoverObject !== "undefined") {
        return KLBrowserExtension.popoverObjectEvent;
    }
    else {
        return "unknownLocation";
    }
};
KL.startContextListener = function(customListener, listenerObject) {
    try {
        if(KL.whereAmI() == KL.contentObjectEvent) {
            listenerObject = KL.hasDefaultArgumentValue(listenerObject, KLContentObject);
            KL.startContentContextListener(listenerObject, customListener);
        }
        else if(KL.whereAmI() == KL.globalObjectEvent) {
            listenerObject = KL.hasDefaultArgumentValue(listenerObject, KLGlobalObject);
            KL.startGlobalContextListener(listenerObject, customListener);
        }
        else if(KL.whereAmI() == KL.popoverObjectEvent) {
            listenerObject = KL.hasDefaultArgumentValue(listenerObject, KLPopoverObject);            
            KL.startPopoverContextListener(listenerObject, customListener);        
        }        
    }
    catch(e) {
        KL.logError(KL.whereAmI() + " listener could not be defined");
    }
};
// [TODO] keep DRY
KL.callContentObject = function(method, data, tabId, callback, isAsync) {
    callback = KL.hasDefaultArgumentValue(callback, function(){});
    data = KL.hasDefaultArgumentValue(data, {});
    isAsync = KL.hasDefaultArgumentValue(isAsync, false);
    KL.getFromToHandler(KL.whereAmI(), KL.contentObjectEvent)(method, data, tabId, callback, isAsync);
};
KL.callActiveContentObject = function(method, data, callback, isAsync) {
    KL.getActiveTabId(function (tabId) {
        callback = KL.hasDefaultArgumentValue(callback, function(){});
        data = KL.hasDefaultArgumentValue(data, {});
        isAsync = KL.hasDefaultArgumentValue(isAsync, false);
        KL.getFromToHandler(KL.whereAmI(), KL.contentObjectEvent)(method, data, tabId, callback, isAsync);
    });
}
KL.callGlobalObject = function(method, data, callback, isAsync) {
    callback = KL.hasDefaultArgumentValue(callback, function(){});
    data = KL.hasDefaultArgumentValue(data, {});
    isAsync = KL.hasDefaultArgumentValue(isAsync, false);
    KL.getFromToHandler(KL.whereAmI(), KL.globalObjectEvent)(method, data, callback, isAsync);
};
KL.callPopoverObject = function(method, data, callback, isAsync) {
    callback = KL.hasDefaultArgumentValue(callback, function(){});
    data = KL.hasDefaultArgumentValue(data, {});
    isAsync = KL.hasDefaultArgumentValue(isAsync, false);
    KL.getFromToHandler(KL.whereAmI(), KL.popoverObjectEvent)(method, data, callback, isAsync);
};
var sendMessageSelfImplementation = function(listenerObject, methodName, data, callback, isAsync) {
    (function(listenerObject, methodName, data, callback, isAsync) {
        if(typeof listenerObject[methodName] !== "undefined") {
			if (isAsync)
				listenerObject[methodName](data, callback);
			else
				callback(listenerObject[methodName](data));        
        }
        else {
            KL.logError("no " + methodName + " in object");
            KL.logError(listenerObject);
        }        
    })(listenerObject, methodName, data, callback, isAsync);
};
KL.setFromToHandler(KL.contentObjectEvent, KL.contentObjectEvent, function(methodName, data, dummy, callback, isAsync) {
    // from content to content
    sendMessageSelfImplementation(KLContentObject, methodName, data, callback, isAsync);
});
KL.setFromToHandler(KL.globalObjectEvent, KL.globalObjectEvent, function(methodName, data, callback) {
    // from global to global
    sendMessageSelfImplementation(KLGlobalObject, methodName, data, callback);
});
KL.setFromToHandler(KL.popoverObjectEvent, KL.popoverObjectEvent, function(methodName, data, callback) {
    // from content to content
    sendMessageSelfImplementation(KLPopoverObject, methodName, data, callback);
});

KL.createElementFromString = function(str) {
    // [TODO] get rid of jQuery
    return $(str);
};

KL.fillTemplate = function(template, data) {
    var filledTemplate = template;
    for(var macro in data) {
        filledTemplate = filledTemplate.replaceAll("%" + macro + "%", data[macro]);
    }
    return filledTemplate;
};

KL.fillTemplateAndCreateElement = function(template, data) {
    return KL.createElementFromString(KL.fillTemplate(template, data));
};

String.prototype.replaceAll = function (find, replace) {
    var str = this;
    return str.replace(new RegExp(find, 'g'), replace);
};

KL.injectStylesheet = function(stylesheetName) {
    var head = document.head,
        link = document.createElement('link')

    link.type = 'text/css';
    link.rel = 'stylesheet';
    link.href = KLBrowserExtension.getExtensionResourcePath() + "/" + stylesheetName;

    head.appendChild(link)
};
/*
    [TODO] coding convention
*/
// GLOBAL TODO: unsaw global and popover pages code (it's in native code)
KLBrowserExtension.getDocument = function() {
    return window.document;
};
KLBrowserExtension.getExtensionResourcePath = function(res, path) {
    if (res.charAt(0) === '/') res = res.substr(1);
    return safari.extension.baseURI + res + (path ? path : "");
};
KLBrowserExtension.getBeforeNavigateTabId = function(event) {
    return event.target;
}
KLBrowserExtension.setTabUrl = function(tabId, toUrl) {
    tabId.url = toUrl;
}
var sendMessageImplementation = function(sender, listenerType, methodName, data, callback, isAsync, tabId) {
    (function(sender, listenerType, methodName, data, callback, isAsync, tabId) {
        var temporaryCallbackName = KLBrowserExtension.getGuid();
        var temporaryCallbackFunction = function(response) {
            if(response.name == temporaryCallbackName) {
                callback(response.message);
                sender.removeEventListener(temporaryCallbackFunction);
            }
        };
        sender.addEventListener("message", temporaryCallbackFunction);
        KLBrowserExtension.dispatchMessage(listenerType, {
            "callbackName" : temporaryCallbackName,
            "data"         : data,
            "methodName"   : methodName,
            "isAsync"      : isAsync
        }, tabId);
    })(sender, listenerType, methodName, data, callback, isAsync, tabId);
};

KL.setFromToHandler(KL.contentObjectEvent, KL.globalObjectEvent, function(methodName, data, callback, isAsync) {
    // from content to global
    sendMessageImplementation(safari.self, KL.globalObjectEvent, methodName, data, callback, isAsync);
});
KL.setFromToHandler(KL.contentObjectEvent, KL.popoverObjectEvent, function(methodName, data, callback, isAsync) {
    // from content to popover
    sendMessageImplementation(safari.self, KL.popoverObjectEvent, methodName, data, callback, isAsync);
});

var startContextListenerImplementation = function(globalObject, listeningParent, listenerType, customListener) {
    (function(globalObject, listeningParent, listenerType) {
        listeningParent.addEventListener("message", function(event) {
            if(event.type === "message" && event.name == listenerType) {
                if(typeof globalObject[event.message.methodName] !== "undefined") {
                    // [TODO] check if method actually returned an object
                    if(event.message.isAsync) {
                        globalObject[event.message.methodName](event.message.data, function(result) {
                            KLBrowserExtension.dispatchMessage(event.message.callbackName, result, event.target);
                        });
                    }
                    else {
                        KLBrowserExtension.dispatchMessage(event.message.callbackName, globalObject[event.message.methodName](event.message.data), event.target);
                    }
                }
                else if(typeof customListener !== "undefined") {
                    if(event.message.isAsync) {
                        customListener(event, function(result) {
                            KLBrowserExtension.dispatchMessage(event.message.callbackName, result, event.target);
                        });
                    }
                    else {
                        KLBrowserExtension.dispatchMessage(event.message.callbackName, customListener(event), event.target);
                    }
                }
            }
        }, false);
    })(globalObject, listeningParent, listenerType);
};
KL.startContentContextListener = function(listenerObject, customListener) {
    startContextListenerImplementation(listenerObject, safari.self, KL.contentObjectEvent, customListener);
};

KLBrowserExtension.addBeforeNavigateEventListener = function(handler) {
    // call event.preventDefault() to prevent loading
    safari.application.addEventListener("navigate", function(event) {
        
        KL.debugMessage("beforeNavigate event: ");
        KL.debugMessage(event);
        KL.debugMessage(event.target.url)
        
        if(typeof event.target.url !== "undefined" && event.target.url.length > 0) {
            var scheme = event.target.url.split("://")[0];
            if(scheme === "http" || scheme === "https")
                if(!handler(event))
                    event.preventDefault();
        }
    }, true);
};
KLBrowserExtension.openApplication = function(url) {
    var tab = KL.openNewTab(url + "://", "background");
    setTimeout(function() {
        // [TODO] is there a way to use any listener?
        tab.close();
    }, 500);
};
KLBrowserExtension.addPageLoadedEventListener = function(handler) {
    safari.application.addEventListener("navigate", handler, true);
};
KLBrowserExtension.addPageClosedEventListener = function(handler) {
    safari.application.addEventListener("close", handler, true);
};
KLBrowserExtension.addTabOpenEventListener = function(handler) {
    safari.application.addEventListener("activate", handler, true);
};
var dispatchMessageToTab = function(name, message, tab) {
    tab.page.dispatchMessage(name, message);
};
KLBrowserExtension.dispatchMessage = function(name, message, tab) {
    message = KL.hasDefaultArgumentValue(message, {});
    name = KL.hasDefaultArgumentValue(name, "unknownMessage");
    if(KL.whereAmI() === KL.contentObjectEvent) {
        safari.extension.dispatchMessage(name, message);
    }
    else {
        if(message.listenerType !== KL.contentObjectEvent && typeof safari.application.dispatchMessage !== "undefined") {
            safari.application.dispatchMessage(name, message);
        }
        if(typeof tab !== "undefined" && typeof tab.page !== "undefined") {
            dispatchMessageToTab(name, message, tab);
        }
        else {
            if(typeof safari.application.activeBrowserWindow.activeTab.page !== "undefined") {
                safari.application.activeBrowserWindow.activeTab.page.dispatchMessage(name, message);
            }
            else {
                KL.logError("no page in safari.application.activeBrowserWindow.activeTab");
            }
        }
    }
};
KLBrowserExtension.getSetting = function(settingName) {
    return safari.extension.settings[settingName];
};
KLBrowserExtension.setSetting = function(settingName, settingValue) {
    safari.extension.settings[settingName] = settingValue;
};
KLBrowserExtension.openNewTab = function(url, visible) {
    var tab = safari.application.activeBrowserWindow.openTab(visible);
    if(url.split("://").length > 1)
        tab.url = url;
    else
        tab.url = "http://" + url;
    return tab;
};

KLBrowserExtension.getBrowserId = function() {
    return "com.apple.Safari";
}
